CREATE FUNCTION dbo.CFUJ_Moratoria_Deuda_Generada(@pJson VARCHAR(8000))
RETURNS DECIMAL(12,2)
AS
BEGIN
DECLARE @Deuda					DECIMAL(20,2)
DECLARE @Json_Envio				VARCHAR(8000)

/*Variables recibidas por parmetro a traves del JSON*/
DECLARE @pId_Cliente	INT
DECLARE @Id_Producto    VARCHAR(14)

SET @Id_Producto = CONVERT(VARCHAR(14),ISNULL(dbo.CF_xParam('Prod_Cuota_Social'),''))

SET @pId_Cliente		= ISNULL(CONVERT(INT, dbo.CF_JSON_VALUE(@pJson,'Id_Cliente')), 0)

SET @Deuda = (SELECT SUM(Saldo)
                                    FROM cbtes c, cbtes_tipos t
                                    WHERE c.id_tipo_cbte = t.id_tipo_cbte
                                    AND t.Compromete_Factura IN ( 1 , -1)
                                    AND c.Fecha < GETDATE() - 1
                                    AND c.Id_Estado_Cbte IN (1,4)
                                    AND EXISTS (SELECT 1 FROM Cbtes_Items i
                                            WHERE i.id_trans = c.id_trans
                                            AND i.id_producto = @Id_Producto)
                                    AND c.id_cliente = @pId_Cliente)


RETURN ISNULL(@Deuda, 0)
END